/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args){$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback){$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback){$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});var wpAjaxUrl='https://shoppersview.com/wp-admin/admin-ajax.php';var flBuilderUrl='https://shoppersview.com/wp-content/plugins/beaver-builder-lite-version/';var FLBuilderLayoutConfig={anchorLinkAnimations:{duration:1000,easing:'swing',offset:100},paths:{pluginUrl:'https://shoppersview.com/wp-content/plugins/beaver-builder-lite-version/',wpAjaxUrl:'https://shoppersview.com/wp-admin/admin-ajax.php'},breakpoints:{small:768,medium:992,large:1200},waypoint:{offset:80},emptyColWidth:'0%'};(function($){if(typeof FLBuilderLayout!='undefined'){return;}
FLBuilderLayout={init:function(){FLBuilderLayout._destroy();FLBuilderLayout._initClasses();FLBuilderLayout._initBackgrounds();FLBuilderLayout._initRowShapeLayerHeight();if(0===$('.fl-builder-edit').length){FLBuilderLayout._initModuleAnimations();FLBuilderLayout._initAnchorLinks();FLBuilderLayout._initHash();FLBuilderLayout._initForms();FLBuilderLayout._reorderMenu();}
else{FLBuilderLayout._initNestedColsWidth();}},refreshGalleries:function(element){var $element='undefined'==typeof element?$('body'):$(element),mfContent=$element.find('.fl-mosaicflow-content'),wmContent=$element.find('.fl-gallery'),mfObject=null;if(mfContent){mfObject=mfContent.data('mosaicflow');if(mfObject){mfObject.columns=$([]);mfObject.columnsHeights=[];mfContent.data('mosaicflow',mfObject);mfContent.mosaicflow('refill');}}
if(wmContent){wmContent.trigger('refreshWookmark');}},refreshGridLayout:function(element){var $element='undefined'==typeof element?$('body'):$(element),msnryContent=$element.find('.masonry');if(msnryContent.length){msnryContent.masonry('layout');}},reloadSlider:function(content){var $content='undefined'==typeof content?$('body'):$(content);if($content.find('.bx-viewport > div').length>0){$.each($content.find('.bx-viewport > div'),function(key,slider){setTimeout(function(){$(slider).data('bxSlider').reloadSlider();},100);});}},resizeAudio:function(element){var $element='undefined'==typeof element?$('body'):$(element),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio'),player=null,mejsPlayer=null,rail=null,railWidth=400;if(audioPlayers.length&&typeof mejs!=='undefined'){audioPlayers.each(function(){player=$(this);mejsPlayer=mejs.players[player.attr('id')];rail=player.find('.mejs-controls .mejs-time-rail');var innerMejs=player.find('.mejs-inner'),total=player.find('.mejs-controls .mejs-time-total');if(typeof mejsPlayer!=='undefined'){railWidth=Math.ceil(player.width()*0.8);if(innerMejs.length){rail.css('width',railWidth+'px!important');mejsPlayer.options.autosizeProgress=true;setTimeout(function(){mejsPlayer.setControlsSize();},50);player.find('.mejs-inner').css({visibility:'visible',height:'inherit'});}}});}},preloadAudio:function(element){var $element='undefined'==typeof element?$('body'):$(element),contentWrap=$element.closest('.fl-accordion-item'),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio');if(!contentWrap.hasClass('fl-accordion-item-active')&&audioPlayers.find('.mejs-inner').length){audioPlayers.find('.mejs-inner').css({visibility:'hidden',height:0});}},resizeSlideshow:function(){if(typeof YUI!=='undefined'){YUI().use('node-event-simulate',function(Y){Y.one(window).simulate("resize");});}},reloadGoogleMap:function(element){var $element='undefined'==typeof element?$('body'):$(element),googleMap=$element.find('iframe[src*="google.com/maps"]');if(googleMap.length){googleMap.attr('src',function(i,val){return val;});}},_destroy:function(){var win=$(window);win.off('scroll.fl-bg-parallax');win.off('resize.fl-bg-video');},_isTouch:function(){if(('ontouchstart'in window)||(window.DocumentTouch&&document instanceof DocumentTouch)){return true;}
return false;},_isMobile:function(){return/Mobile|Android|Silk\/|Kindle|BlackBerry|Opera Mini|Opera Mobi|webOS/i.test(navigator.userAgent);},_initClasses:function(){var body=$('body'),ua=navigator.userAgent;if(!body.hasClass('archive')&&$('.fl-builder-content-primary').length>0){body.addClass('fl-builder');}
if(FLBuilderLayout._isTouch()){body.addClass('fl-builder-touch');}
if(FLBuilderLayout._isMobile()){body.addClass('fl-builder-mobile');}
if($(window).width()<FLBuilderLayoutConfig.breakpoints.small){body.addClass('fl-builder-breakpoint-small');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.small&&$(window).width()<FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-medium');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.medium&&$(window).width()<FLBuilderLayoutConfig.breakpoints.large){body.addClass('fl-builder-breakpoint-large');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.large){body.addClass('fl-builder-breakpoint-default');}
if(ua.indexOf('Trident/7.0')>-1&&ua.indexOf('rv:11.0')>-1){body.addClass('fl-builder-ie-11');}},_initBackgrounds:function(){var win=$(window);if($('.fl-row-bg-parallax').length>0&&!FLBuilderLayout._isMobile()){FLBuilderLayout._scrollParallaxBackgrounds();FLBuilderLayout._initParallaxBackgrounds();win.on('resize.fl-bg-parallax',FLBuilderLayout._initParallaxBackgrounds);win.on('scroll.fl-bg-parallax',FLBuilderLayout._scrollParallaxBackgrounds);}
if($('.fl-bg-video').length>0){FLBuilderLayout._initBgVideos();FLBuilderLayout._resizeBgVideos();var resizeBGTimer=null;win.on('resize.fl-bg-video',function(e){clearTimeout(resizeBGTimer);resizeBGTimer=setTimeout(function(){FLBuilderLayout._resizeBgVideos(e);},100);});}},_initParallaxBackgrounds:function(){$('.fl-row-bg-parallax').each(FLBuilderLayout._initParallaxBackground);},_initParallaxBackground:function(){var row=$(this),content=row.find('> .fl-row-content-wrap'),winWidth=$(window).width(),screenSize='',imageSrc={default:'',medium:'',responsive:'',};imageSrc.default=row.data('parallax-image')||'';imageSrc.medium=row.data('parallax-image-medium')||imageSrc.default;imageSrc.responsive=row.data('parallax-image-responsive')||imageSrc.medium;if(winWidth>FLBuilderLayoutConfig.breakpoints.medium){screenSize='default';}else if(winWidth>FLBuilderLayoutConfig.breakpoints.small&&winWidth<=FLBuilderLayoutConfig.breakpoints.medium){screenSize='medium';}else if(winWidth<=FLBuilderLayoutConfig.breakpoints.small){screenSize='responsive';}
content.css('background-image','url('+imageSrc[screenSize]+')');row.data('current-image-loaded',screenSize);},_scrollParallaxBackgrounds:function(){$('.fl-row-bg-parallax').each(FLBuilderLayout._scrollParallaxBackground);},_scrollParallaxBackground:function(){var win=$(window),row=$(this),content=row.find('> .fl-row-content-wrap'),speed=row.data('parallax-speed'),offset=content.offset(),yPos=-((win.scrollTop()-offset.top)/ speed),initialOffset=(row.data('parallax-offset')!=null)?row.data('parallax-offset'):0,totalOffset=yPos-initialOffset;content.css('background-position','center '+totalOffset+'px');},_initBgVideos:function(){$('.fl-bg-video').each(FLBuilderLayout._initBgVideo);},_initBgVideo:function(){var wrap=$(this),width=wrap.data('width'),height=wrap.data('height'),mp4=wrap.data('mp4'),youtube=wrap.data('youtube'),vimeo=wrap.data('vimeo'),mp4Type=wrap.data('mp4-type'),webm=wrap.data('webm'),webmType=wrap.data('webm-type'),fallback=wrap.data('fallback'),loaded=wrap.data('loaded'),videoMobile=wrap.data('video-mobile'),fallbackTag='',videoTag=null,mp4Tag=null,webmTag=null;if(loaded){return;}
videoTag=$('<video autoplay loop muted playsinline></video>');if('undefined'!=typeof fallback&&''!=fallback){videoTag.attr('poster','data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7')
videoTag.css({backgroundImage:'url("'+fallback+'")',backgroundColor:'transparent',backgroundRepeat:'no-repeat',backgroundSize:'cover',backgroundPosition:'center center',})}
if('undefined'!=typeof mp4&&''!=mp4){mp4Tag=$('<source />');mp4Tag.attr('src',mp4);mp4Tag.attr('type',mp4Type);videoTag.append(mp4Tag);}
if('undefined'!=typeof webm&&''!=webm){webmTag=$('<source />');webmTag.attr('src',webm);webmTag.attr('type',webmType);videoTag.append(webmTag);}
if(!FLBuilderLayout._isMobile()||(FLBuilderLayout._isMobile()&&"yes"==videoMobile)){if('undefined'!=typeof youtube){FLBuilderLayout._initYoutubeBgVideo.apply(this);}
else if('undefined'!=typeof vimeo){FLBuilderLayout._initVimeoBgVideo.apply(this);}
else{wrap.append(videoTag);}}
else{videoTag.attr('src','')
wrap.append(videoTag);}
wrap.data('loaded',true);},_initYoutubeBgVideo:function(){var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),startTime='undefined'!==typeof playerWrap.data('start')?playerWrap.data('start'):0,startTime='undefined'!==typeof playerWrap.data('t')&&startTime===0?playerWrap.data('t'):startTime,endTime='undefined'!==typeof playerWrap.data('end')?playerWrap.data('end'):0,loop='undefined'!==typeof playerWrap.data('loop')?playerWrap.data('loop'):1,stateCount=0,player,fallback_showing;if(videoId){fallback=playerWrap.data('fallback')||false
if(fallback){playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');fallbackTag.css('background-size','cover');fallbackTag.css('transition','background-image 1s')
playerWrap.append(fallbackTag);fallback_showing=true;}
FLBuilderLayout._onYoutubeApiReady(function(YT){setTimeout(function(){player=new YT.Player(videoPlayer[0],{videoId:videoId,events:{onReady:function(event){if("no"===enableAudio||FLBuilderLayout._isMobile()){event.target.mute();}
else if("yes"===enableAudio&&event.target.isMuted){event.target.unMute();}
playerWrap.data('YTPlayer',player);FLBuilderLayout._resizeYoutubeBgVideo.apply(playerWrap);event.target.playVideo();if(audioButton.length>0&&!FLBuilderLayout._isMobile()){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}},onStateChange:function(event){if(event.data===1){if(fallback_showing){$('.fl-bg-video-fallback').css('background-image','url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)')}}
if(stateCount<4){stateCount++;}
if(stateCount>1&&(-1===event.data||2===event.data)&&"yes"===enableAudio){player.mute();player.playVideo();audioButton.show();}
if(event.data===YT.PlayerState.ENDED&&1===loop){if(startTime>0){player.seekTo(startTime);}
else{player.playVideo();}}},onError:function(event){console.info('YT Error: '+event.data)
FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)}},playerVars:{playsinline:FLBuilderLayout._isMobile()?1:0,controls:0,showinfo:0,rel:0,start:startTime,end:endTime,}});},1);});}},_onErrorYoutubeVimeo:function(playerWrap){fallback=playerWrap.data('fallback')||false
if(!fallback){return false;}
playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');playerWrap.append(fallbackTag);},_onYoutubeApiReady:function(callback){if(window.YT&&YT.loaded){callback(YT);}else{setTimeout(function(){FLBuilderLayout._onYoutubeApiReady(callback);},350);}},_initVimeoBgVideo:function(){var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),player,width=playerWrap.outerWidth(),ua=navigator.userAgent;if(typeof Vimeo!=='undefined'&&videoId){player=new Vimeo.Player(videoPlayer[0],{id:videoId,loop:true,title:false,portrait:false,background:true,autopause:false,muted:true});playerWrap.data('VMPlayer',player);if("no"===enableAudio){player.setVolume(0);}
else if("yes"===enableAudio){if(ua.indexOf("Safari")>-1||ua.indexOf("Chrome")>-1||ua.indexOf("Firefox")>-1){player.setVolume(0);audioButton.show();}
else{player.setVolume(1);}}
player.play().catch(function(error){FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)});if(audioButton.length>0){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}}},_toggleBgVideoAudio:function(e){var player=e.data.player,control=e.data.button.find('.fl-audio-control');if(control.hasClass('fa-volume-off')){control.removeClass('fa-volume-off').addClass('fa-volume-up');e.data.button.find('.fa-times').hide();if('function'===typeof player.unMute){player.unMute();}
else{player.setVolume(1);}}
else{control.removeClass('fa-volume-up').addClass('fa-volume-off');e.data.button.find('.fa-times').show();if('function'===typeof player.unMute){player.mute();}
else{player.setVolume(0);}}},_videoBgSourceError:function(e){var source=$(e.target),wrap=source.closest('.fl-bg-video'),vid=wrap.find('video'),fallback=wrap.data('fallback'),fallbackTag='';source.remove();if(vid.find('source').length){return;}else if(''!==fallback){fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+fallback+')');wrap.append(fallbackTag);vid.remove();}},_resizeBgVideos:function(){$('.fl-bg-video').each(function(){FLBuilderLayout._resizeBgVideo.apply(this);if($(this).parent().find('img').length>0){$(this).parent().imagesLoaded($.proxy(FLBuilderLayout._resizeBgVideo,this));}});},_resizeBgVideo:function(){if(0===$(this).find('video').length&&0===$(this).find('iframe').length){return;}
var wrap=$(this),wrapHeight=wrap.outerHeight(),wrapWidth=wrap.outerWidth(),vid=wrap.find('video'),vidHeight=wrap.data('height'),vidWidth=wrap.data('width'),newWidth=wrapWidth,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newLeft=0,newTop=0,iframe=wrap.find('iframe'),isRowFullHeight=$(this).closest('.fl-row-bg-video').hasClass('fl-row-full-height'),vidCSS={top:'50%',left:'50%',transform:'translate(-50%,-50%)',};if(vid.length){if(vidHeight===''||typeof vidHeight==='undefined'||vidWidth===''||typeof vidWidth==='undefined'){vid.css({'left':'0px','top':'0px','width':newWidth+'px'});vid.on('loadedmetadata',FLBuilderLayout._resizeOnLoadedMeta);return;}
if(!isRowFullHeight){if(newHeight<wrapHeight){newHeight=wrapHeight;newLeft=-((newWidth-wrapWidth)/ 2);newWidth=vidHeight?Math.round(vidWidth*wrapHeight/vidHeight):newWidth;}
else{newTop=-((newHeight-wrapHeight)/2);}
vidCSS={left:newLeft+'px',top:newTop+'px',height:newHeight+'px',width:newWidth+'px',}}
vid.css(vidCSS);}
else if(iframe.length){if(typeof wrap.data('youtube')!=='undefined'){FLBuilderLayout._resizeYoutubeBgVideo.apply(this);}}},_resizeOnLoadedMeta:function(){var video=$(this),wrapHeight=video.parent().outerHeight(),wrapWidth=video.parent().outerWidth(),vidWidth=video[0].videoWidth,vidHeight=video[0].videoHeight,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newWidth=wrapWidth,newLeft=0,newTop=0;if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
video.parent().data('width',vidWidth);video.parent().data('height',vidHeight);video.css({'left':newLeft+'px','top':newTop+'px','width':newWidth+'px','height':newHeight+'px'});},_resizeYoutubeBgVideo:function(){var wrap=$(this),wrapWidth=wrap.outerWidth(),wrapHeight=wrap.outerHeight(),player=wrap.data('YTPlayer'),video=player?player.getIframe():null,aspectRatioSetting='16:9',aspectRatioArray=aspectRatioSetting.split(':'),aspectRatio=aspectRatioArray[0]/ aspectRatioArray[1],ratioWidth=wrapWidth / aspectRatio,ratioHeight=wrapHeight*aspectRatio,isWidthFixed=wrapWidth / wrapHeight>aspectRatio,width=isWidthFixed?wrapWidth:ratioHeight,height=isWidthFixed?ratioWidth:wrapHeight;if(video){$(video).width(width).height(height);}},_initModuleAnimations:function(){if(typeof jQuery.fn.waypoint!=='undefined'){$('.fl-animation').each(function(){var node=$(this),nodeTop=node.offset().top,winHeight=$(window).height(),bodyHeight=$('body').height(),waypoint=FLBuilderLayoutConfig.waypoint,offset='80%';if(typeof waypoint.offset!==undefined){offset=FLBuilderLayoutConfig.waypoint.offset+'%';}
if(bodyHeight-nodeTop<winHeight*0.2){offset='100%';}
node.waypoint({offset:offset,handler:FLBuilderLayout._doModuleAnimation});});}},_doModuleAnimation:function(){var module='undefined'==typeof this.element?$(this):$(this.element),delay=parseFloat(module.data('animation-delay')),duration=parseFloat(module.data('animation-duration'));if(!isNaN(duration)){module.css('animation-duration',duration+'s');}
if(!isNaN(delay)&&delay>0){setTimeout(function(){module.addClass('fl-animated');},delay*1000);}else{setTimeout(function(){module.addClass('fl-animated');},1);}},_initHash:function(){var hash=window.location.hash.replace('#','').split('/').shift(),element=null,tabs=null,responsiveLabel=null,tabIndex=null,label=null;if(''!==hash){try{element=$('#'+hash);if(element.length>0){if(element.hasClass('fl-accordion-item')){setTimeout(function(){element.find('.fl-accordion-button').trigger('click');},100);}
if(element.hasClass('fl-tabs-panel')){setTimeout(function(){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');label[0].click();FLBuilderLayout._scrollToElement(element);},100);}}}
catch(e){}}},_initAnchorLinks:function(){$('a').each(FLBuilderLayout._initAnchorLink);},_initAnchorLink:function(){var link=$(this),href=link.attr('href'),loc=window.location,id=null,element=null,flNode=false;if('undefined'!=typeof href&&href.indexOf('#')>-1&&link.closest('svg').length<1){if(loc.pathname.replace(/^\//,'')==this.pathname.replace(/^\//,'')&&loc.hostname==this.hostname){try{id=href.split('#').pop();if(!id){return;}
element=$('#'+id);if(element.length>0){flNode=element.hasClass('fl-row')||element.hasClass('fl-col')||element.hasClass('fl-module');if(!element.hasClass('fl-no-scroll')&&(link.hasClass('fl-scroll-link')||flNode)){$(link).on('click',FLBuilderLayout._scrollToElementOnLinkClick);}
if(element.hasClass('fl-accordion-item')){$(link).on('click',FLBuilderLayout._scrollToAccordionOnLinkClick);}
if(element.hasClass('fl-tabs-panel')){$(link).on('click',FLBuilderLayout._scrollToTabOnLinkClick);}}}
catch(e){}}}},_scrollToElementOnLinkClick:function(e,callback){var element=$('#'+$(this).attr('href').split('#').pop());FLBuilderLayout._scrollToElement(element,callback);e.preventDefault();},_scrollToElement:function(element,callback){var config=FLBuilderLayoutConfig.anchorLinkAnimations,dest=0,win=$(window),doc=$(document);if(element.length>0){if('fixed'===element.css('position')||'fixed'===element.parent().css('position')){dest=element.position().top;}
else if(element.offset().top>doc.height()-win.height()){dest=doc.height()-win.height();}
else{dest=element.offset().top-config.offset;}
$('html, body').animate({scrollTop:dest},config.duration,config.easing,function(){if('undefined'!=typeof callback){callback();}
if(undefined!=element.attr('id')){if(history.pushState){history.pushState(null,null,'#'+element.attr('id'));}
else{window.location.hash=element.attr('id');}}});}},_scrollToAccordionOnLinkClick:function(e){var element=$('#'+$(this).attr('href').split('#').pop());if(element.length>0){var callback=function(){if(element){element.find('.fl-accordion-button').trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}},_scrollToTabOnLinkClick:function(e){var element=$('#'+$(this).attr('href').split('#').pop()),tabs=null,label=null,responsiveLabel=null;if(element.length>0){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){var callback=function(){if(element){responsiveLabel.trigger($.Event('click',{which:1}));}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}
e.preventDefault();}},_initForms:function(){if(!FLBuilderLayout._hasPlaceholderSupport){$('.fl-form-field input').each(FLBuilderLayout._initFormFieldPlaceholderFallback);}
$('.fl-form-field input').on('focus',FLBuilderLayout._clearFormFieldError);},_hasPlaceholderSupport:function(){var input=document.createElement('input');return'undefined'!=input.placeholder;},_initFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if('undefined'!=placeholder&&''===val){field.val(placeholder);field.on('focus',FLBuilderLayout._hideFormFieldPlaceholderFallback);field.on('blur',FLBuilderLayout._showFormFieldPlaceholderFallback);}},_hideFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(val==placeholder){field.val('');}},_showFormFieldPlaceholderFallback:function(){var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(''===val){field.val(placeholder);}},_clearFormFieldError:function(){var field=$(this);field.removeClass('fl-form-error');field.siblings('.fl-form-error-message').hide();},_initRowShapeLayerHeight:function(){FLBuilderLayout._adjustRowShapeLayerHeight();$(window).on('resize',FLBuilderLayout._adjustRowShapeLayerHeight);},_initNestedColsWidth:function(){var nestedCols=$('.fl-col-has-cols');if(nestedCols.length<=0){return;}
$(nestedCols).each(function(index,col){if($(col).width()<=0){$(col).css('width',FLBuilderLayoutConfig.emptyColWidth);}});},_adjustRowShapeLayerHeight:function(){var rowShapeLayers=$('.fl-builder-shape-layer');$(rowShapeLayers).each(function(index){var rowShapeLayer=$(this),shape=$(rowShapeLayer).find('svg'),height=shape.height(),excludeShapes='.fl-builder-shape-circle, .fl-builder-shape-dot-cluster, .fl-builder-shape-topography, .fl-builder-shape-rect';if(!rowShapeLayer.is(excludeShapes)){$(shape).css('height',Math.ceil(height));}});},_string_to_slug:function(str){str=str.replace(/^\s+|\s+$/g,'');if('undefined'==typeof window._fl_string_to_slug_regex){regex=new RegExp('[^a-zA-Z0-9\'":() !.,-_|]','g');}else{regex=new RegExp('[^'+window._fl_string_to_slug_regex+'\'":\(\) !.,-_|\\\p{Letter}]','ug');}
str=str.replace(regex,'').replace(/\s+/g,' ');return str;},_reorderMenu:function(){if($('#wp-admin-bar-fl-builder-frontend-edit-link-default li').length>1){$('#wp-admin-bar-fl-builder-frontend-duplicate-link').appendTo('#wp-admin-bar-fl-builder-frontend-edit-link-default').css('padding-top','5px').css('border-top','2px solid #1D2125').css('margin-top','5px')}}};$(function(){FLBuilderLayout.init();});})(jQuery);;var UABBBlogPosts;(function($){UABBBlogPosts=function(settings){this.nodeClass='.fl-node-'+settings.id;this.id=settings.id;this.wrapperClass=this.nodeClass+' .uabb-blog-posts';this.postClass=this.nodeClass+' .uabb-post-wrapper';this.pagination=settings.pagination;this.is_carousel=settings.is_carousel;this.infinite=settings.infinite;this.arrows=settings.arrows;this.desktop=settings.desktop;this.moduleUrl=settings.moduleUrl;this.loaderUrl=settings.loaderUrl;this.prevArrow=settings.prevArrow;this.nextArrow=settings.nextArrow;this.medium=settings.medium;this.small=settings.small;this.slidesToScroll=settings.slidesToScroll;this.autoplay=settings.autoplay;this.autoplaySpeed=settings.autoplaySpeed;this.dots=settings.dots;this.small_breakpoint=settings.small_breakpoint;this.medium_breakpoint=settings.medium_breakpoint;this.equal_height_box=settings.equal_height_box;this.mesonry_equal_height=settings.mesonry_equal_height;this.uabb_masonary_filter_type=settings.uabb_masonary_filter_type;this.element_space=settings.element_space;if(this.is_carousel=='carousel'){this._uabbBlogPostCarousel();if(this.equal_height_box=='yes'){jQuery(this.nodeClass).find('.uabb-blog-posts-carousel').on('afterChange',this._uabbBlogPostCarouselHeight);jQuery(this.nodeClass).find('.uabb-blog-posts-carousel').on('init',$.proxy(this._uabbBlogPostCarouselEqualHeight,this));}}else if(this.is_carousel=='masonary'){this._uabbBlogPostMasonary();}else if(this.is_carousel=='grid'){this._uabbBlogPostGrid();}
if(settings.blog_image_position=='background'){this._uabbBlogPostImageResize();}
if(this._hasPosts()){this._initInfiniteScroll();}
this._openOnLink();};UABBBlogPosts.prototype={nodeClass:'',wrapperClass:'',is_carousel:'grid',infinite:'',arrows:'',desktop:'',medium:'',small:'',slidesToScroll:'',autoplay:'',autoplaySpeed:'',small_breakpoint:'',medium_breakpoint:'',equal_height_box:'yes',mesonry_equal_height:'no',uabb_masonary_filter_type:'buttons',_hasPosts:function(){return $(this.postClass).length>0;},_initInfiniteScroll:function(){if(this.pagination=='scroll'&&typeof FLBuilder==='undefined'){var $this=this;setTimeout(function(){$this._infiniteScroll();},500);}},_infiniteScroll:function(settings){var $this=this,path=$($this.nodeClass+' .uabb-blogs-pagination a.next').attr('href');pagePattern=/(.*?(\/|\&|\?)paged-[0-9]{1,}(\/|=))([0-9]{1,})+(.*)/;wpPattern=/^(.*?\/?page\/?)(?:\d+)(.*?$)/;pageMatched=null;scrollData={navSelector:$this.nodeClass+' .uabb-blogs-pagination',nextSelector:$this.nodeClass+' .uabb-blogs-pagination a.next',itemSelector:$this.postClass,prefill:true,bufferPx:200,loading:{msgText:'Loading',finishedMsg:'',img:$this.moduleUrl+'/img/ajax-loader-grey.gif',speed:10,}};if(pagePattern.test(path)){scrollData.path=function(currPage){pageMatched=path.match(pagePattern);path=pageMatched[1]+currPage+pageMatched[5];return path;}}
else if(wpPattern.test(path)){scrollData.path=path.match(wpPattern).slice(1);}
$($this.wrapperClass).infinitescroll(scrollData,$.proxy($this._infiniteScrollComplete,$this));setTimeout(function(){$(window).trigger('resize');},100);},_infiniteScrollComplete:function(elements){var $this=this,wrap=$($this.wrapperClass);elements=$(elements);if($this.is_carousel=='masonary'){wrap.isotope('appended',elements);}else if($this.is_carousel=='grid'){wrap.imagesLoaded($.proxy(function(){if($this.equal_height_box=='yes'){$this._uabbBlogPostMesonryHeight();}
wrap.isotope('appended',elements);wrap.isotope('layout');},$this));}},_uabbBlogPostCarousel:function(){var $this=this;if($this.equal_height_box=='yes'){$this._uabbBlogPostCarouselEqualHeight();}
var grid=jQuery($this.nodeClass).find('.uabb-blog-posts-carousel');jQuery($this.nodeClass).find('.uabb-blog-posts-carousel').uabbslick({dots:$this.dots,infinite:$this.infinite,arrows:$this.arrows,lazyLoad:'ondemand',slidesToShow:$this.desktop,slidesToScroll:$this.slidesToScroll,autoplay:$this.autoplay,prevArrow:'<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button"><i class=" '+$this.prevArrow+' "></i></button>',nextArrow:'<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button"><i class="'+$this.nextArrow+' "></i></button>',autoplaySpeed:$this.autoplaySpeed,adaptiveHeight:false,responsive:[{breakpoint:$this.medium_breakpoint,settings:{slidesToShow:$this.medium,slidesToScroll:$this.medium,}},{breakpoint:$this.small_breakpoint,settings:{slidesToShow:$this.small,slidesToScroll:$this.small,}}]});},_uabbBlogPostMasonary:function(){var $this=this,id=$this.id,nodeClass=$this.nodeClass;if($this.mesonry_equal_height=='yes'){LayoutMode='fitRows';}
else{LayoutMode='masonry';}
$grid=jQuery(nodeClass).find('.uabb-blog-posts-masonary').isotope({layoutMode:LayoutMode,itemSelector:'.uabb-blog-posts-masonary-item-'+$this.id,masonry:{columnWidth:'.uabb-blog-posts-masonary-item-'+$this.id}});if($this.uabb_masonary_filter_type=='drop-down'){jQuery(nodeClass).find('.uabb-masonary-filters').on('change',function(){value=jQuery(nodeClass).find('.uabb-masonary-filters option:selected').data('filter');jQuery(nodeClass+' .uabb-blog-posts-masonary').isotope({filter:value})});}
else{jQuery(nodeClass).find('.uabb-masonary-filters .uabb-masonary-filter-'+id).on('click',function(){jQuery(this).siblings().removeClass('uabb-masonary-current');jQuery(this).addClass('uabb-masonary-current');var value=jQuery(this).data('filter');jQuery(nodeClass+' .uabb-blog-posts-masonary').isotope({filter:value})});jQuery(nodeClass).find('.uabb-masonary-filters .uabb-masonary-filter-'+id).off('keyup').on('keyup',function(e){if(9==e.keyCode){jQuery(this).siblings().removeClass('uabb-masonary-current');jQuery(this).addClass('uabb-masonary-current');}
if(13===e.keyCode){var value=jQuery(this).data('filter');jQuery(nodeClass+' .uabb-blog-posts-masonary').isotope({filter:value})}});}
if($this.mesonry_equal_height=='yes'){$this._uabbBlogPostMesonryHeight();}},_uabbBlogPostGrid:function(){var $this=this,id=$this.id,nodeClass=$this.nodeClass,LayoutMode='fitRows';$grid=jQuery(nodeClass).find('.uabb-blog-posts-grid').isotope({layoutMode:LayoutMode,itemSelector:'.uabb-blog-posts-grid-item-'+$this.id,gutter:parseInt($this.element_space),isFitWidth:true,transitionDuration:0,masonry:{columnWidth:$this.nodeClass+' .uabb-post-grid-sizer'}});if($this.uabb_masonary_filter_type=='drop-down'){jQuery(nodeClass).find('.uabb-masonary-filters').on('change',function(){value=jQuery(nodeClass).find('.uabb-masonary-filters option:selected').data('filter');jQuery(nodeClass+' .uabb-blog-posts-grid').isotope({filter:value})});}
else{jQuery(nodeClass).find('.uabb-masonary-filters .uabb-masonary-filter-'+id).on('click',function(){jQuery(this).siblings().removeClass('uabb-masonary-current');jQuery(this).addClass('uabb-masonary-current');var value=jQuery(this).data('filter');jQuery(nodeClass+' .uabb-blog-posts-grid').isotope({filter:value})});jQuery(nodeClass).find('.uabb-masonary-filters .uabb-masonary-filter-'+id).off('keyup').on('keyup',function(e){if(9==e.keyCode){jQuery(this).siblings().removeClass('uabb-masonary-current');jQuery(this).addClass('uabb-masonary-current');}
if(13===e.keyCode){var value=jQuery(this).data('filter');jQuery(nodeClass+' .uabb-blog-posts-grid').isotope({filter:value})}});}
if($this.equal_height_box=='yes'){jQuery(nodeClass+' .uabb-blog-posts-grid').imagesLoaded($.proxy(function(){this._uabbBlogPostMesonryHeight();setTimeout(()=>{jQuery(nodeClass+' .uabb-blog-posts-grid').isotope('layout');},150);},this));}
$(window).scroll(function(){clearTimeout($.data(this,'scrollTimer'));$.data(this,'scrollTimer',setTimeout(function(){jQuery(nodeClass+' .uabb-blog-posts-grid').isotope('layout');},25));});},_openOnLink:function(){var $this=this,nodeClass=jQuery($this.nodeClass);if($this.is_carousel=='masonary'){var layoutClass='.uabb-blog-posts-masonary';}else if($this.is_carousel=='grid'){var layoutClass='.uabb-blog-posts-grid';}
var pattern=new RegExp('^[\\w\\-]+$');var id=window.location.hash.substring(1);if(pattern.test(id)){$($this.nodeClass+layoutClass).each(function(){var selector=$(this);var filters=nodeClass.find('.uabb-masonary-filters');if(filters.length>0){if(''!==id){id='.'+id.toLowerCase();def_cat=id;def_cat_sel=filters.find('[data-filter="'+id+'"]');if(0===def_cat_sel.length){return;}
if(def_cat_sel.length>0){def_cat_sel.siblings().removeClass('uabb-masonary-current');def_cat_sel.addClass('uabb-masonary-current');}}}
selector.isotope({filter:def_cat,});});}},_uabbBlogPostCarouselEqualHeight:function(){var $this=this,id=$this.id,nodeClass=$this.nodeClass,small_breakpoint=$this.small_breakpoint,medium_breakpoint=$this.medium_breakpoint,desktop=$this.desktop,medium=$this.medium,small=$this.small,node=jQuery(nodeClass),grid=node.find('.uabb-blog-posts'),post_wrapper=grid.find('.uabb-post-wrapper'),post_active=grid.find('.uabb-post-wrapper.slick-active'),max_height=-1,wrapper_height=-1,i=1,counter=parseInt(desktop),childEleCount=post_wrapper.length,remainingNodes=(childEleCount%counter);if(window.innerWidth<=small_breakpoint){counter=parseInt(small);}else if(window.innerWidth>medium_breakpoint){counter=parseInt(desktop);}else{counter=parseInt(medium);}
post_active.each(function(){var $this=jQuery(this),this_height=$this.outerHeight(),selector=$this.find('.uabb-blog-posts-shadow'),blog_post=$this.find('.uabb-blog-post-inner-wrap'),selector_height=selector.outerHeight(),blog_post_height=blog_post.outerHeight();if(max_height<blog_post_height){max_height=blog_post_height;}
if(wrapper_height<this_height){wrapper_height=this_height}});post_active.each(function(){var $this=jQuery(this);$this.find('.uabb-blog-posts-shadow').css('height',max_height-8);});grid.find('.slick-list.draggable').animate({height:max_height},{duration:200,easing:'linear'});max_height=-1;wrapper_height=-1;post_wrapper.each(function(){$this=jQuery(this),selector=$this.find('.uabb-blog-posts-shadow'),selector_height=selector.outerHeight();if($this.hasClass('slick-active')){return true;}
selector.css('height',selector_height);});},_uabbBlogPostCarouselHeight:function(slick,currentSlide){var $this=$(this),id=$this.parents('.fl-module-blog-posts').data('node'),nodeClass='.fl-node-'+id,grid=$(nodeClass).find('.uabb-blog-posts-carousel'),post_wrapper=grid.find('.uabb-post-wrapper'),post_active=grid.find('.uabb-post-wrapper.slick-active'),max_height=-1,wrapper_height=-1;post_active.each(function(i){var $this=$(this),this_height=$this.outerHeight(),blog_post=$this.find('.uabb-blog-post-inner-wrap'),blog_post_height=blog_post.outerHeight();if(max_height<blog_post_height){max_height=blog_post_height;}
if(wrapper_height<this_height){wrapper_height=this_height}});post_active.each(function(i){var selector=jQuery(this).find('.uabb-blog-posts-shadow');selector.css("height",max_height);});grid.find('.slick-list.draggable').animate({height:max_height},{duration:200,easing:'linear'});max_height=-1;wrapper_height=-1;post_wrapper.each(function(){var $this=jQuery(this),selector=$this.find('.uabb-blog-posts-shadow'),blog_post=$this.find('.uabb-blog-post-inner-wrap'),blog_post_height=blog_post.outerHeight();if($this.hasClass('slick-active')){return true;}
selector.css('height',blog_post_height);});},_uabbBlogPostMesonryHeight:function(){var $this=this,id=$this.id,nodeClass='.fl-node-'+id,max_height=-1,wrapper_height=-1;if($this.is_carousel=='masonary'){var grid=$(nodeClass).find('.uabb-blog-posts-masonary');}else if($this.is_carousel=='grid'){var grid=$(nodeClass).find('.uabb-blog-posts-grid');}
var post_wrapper=grid.find('.uabb-post-wrapper');post_wrapper.each(function(i){var this_height=$(this).outerHeight(),blog_post=$(this).find('.uabb-blog-post-inner-wrap'),blog_post_height=blog_post.outerHeight();if(max_height<blog_post_height){max_height=blog_post_height;}
if(wrapper_height<this_height){wrapper_height=this_height}});post_wrapper.each(function(i){var selector=jQuery(this).find('.uabb-blog-posts-shadow');selector.css("height",max_height);});},_uabbBlogPostImageResize:function(){var $this=this,id=$this.id,nodeClass=$this.nodeClass,small_breakpoint=$this.small_breakpoint,medium_breakpoint=$this.medium_breakpoint,node=jQuery(nodeClass),grid=node.find('.uabb-blog-posts');grid.find('.uabb-post-wrapper').each(function(){var img_selector=jQuery(this).find('.uabb-post-thumbnail'),img_wrap_height=parseInt(img_selector.height()),img_height=parseInt(img_selector.find('img').height());if(!isNaN(img_wrap_height)&&!isNaN(img_height)){if(img_wrap_height>=img_height){img_selector.find('img').css('min-height','100%');}else{img_selector.find('img').css('min-height','');}}});}};})(jQuery);;(function($){var document_width,document_height;var args={id:'61f05be8acbd0',pagination:'numbers',is_carousel:'feed',infinite:true,arrows:true,desktop:3,moduleUrl:'https://shoppersview.com/wp-content/plugins/bb-ultimate-addon/modules/blog-posts',medium:2,small:1,slidesToScroll:1,prevArrow:'fas fa-angle-left',nextArrow:'fas fa-angle-right',autoplay:false,autoplaySpeed:1000,dots:false,small_breakpoint:768,medium_breakpoint:992,equal_height_box:'yes',uabb_masonary_filter_type:'buttons',mesonry_equal_height:'no',blog_image_position:'top',element_space:''};jQuery(document).ready(function(){jQuery('.uabb-masonary-filters .uabb-masonary-current').trigger('click');var pattern=new RegExp('^\\d+$');var hashval=window.location.hash.substring(1);if(pattern.test(hashval)){if(hashval!=''){jQuery('.fl-node-61f05be8acbd0 .uabb-masonary-filters li').removeClass('uabb-masonary-current');jQuery('.fl-node-61f05be8acbd0 .uabb-masonary-filters li[data-filter=".uabb-masonary-cat-'+hashval+'"]').addClass('uabb-masonary-current');jQuery('.fl-node-61f05be8acbd0 .uabb-masonary-filters .uabb-masonary-filter-61f05be8acbd0.uabb-masonary-current').trigger('click');}}
document_width=$(document).width();document_height=$(document).height();UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){var is_carousel='feed';var child_id=jQuery(selector+' .fl-module-blog-posts').data('node');if(child_id!==null){if(is_carousel==='carousel'){jQuery('.fl-node-'+child_id).find('.uabb-blog-posts-carousel').uabbslick('unslick');}
var child_args={id:child_id,is_carousel:'feed',infinite:true,arrows:true,desktop:3,medium:2,small:1,slidesToScroll:1,autoplay:false,autoplaySpeed:1000,small_breakpoint:768,medium_breakpoint:992,equal_height_box:'yes',blog_image_position:'top'};new UABBBlogPosts(child_args);}});UABBTrigger.addHook('uabb-modal-click',function(argument,selector){var is_carousel='feed';var child_id=jQuery(selector+' .fl-module-blog-posts').data('node');if(child_id!==null){if(is_carousel==='carousel'){jQuery('.fl-node-'+child_id).find('.uabb-blog-posts-carousel').uabbslick('unslick');}
var child_args={id:child_id,is_carousel:'feed',infinite:true,arrows:true,desktop:3,medium:2,small:1,slidesToScroll:1,autoplay:false,autoplaySpeed:1000,small_breakpoint:768,medium_breakpoint:992,equal_height_box:'yes',blog_image_position:'top'};new UABBBlogPosts(child_args);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){var is_carousel='feed';var child_id=jQuery(selector+' .fl-module-blog-posts').data('node');if(child_id!==null){if(is_carousel==='carousel'){jQuery('.fl-node-'+child_id).find('.uabb-blog-posts-carousel').uabbslick('unslick');}
var child_args={id:child_id,is_carousel:'feed',infinite:true,arrows:true,desktop:3,medium:2,small:1,slidesToScroll:1,autoplay:false,autoplaySpeed:1000,small_breakpoint:768,medium_breakpoint:992,equal_height_box:'yes',blog_image_position:'top'};new UABBBlogPosts(child_args);if(is_carousel==='grid'){new UABBBlogPosts(child_args);jQuery('.fl-node-'+child_id+'.uabb-blog-posts-grid').isotope('layout');}}});});jQuery(window).on("load",function(){new UABBBlogPosts(args);});jQuery(window).resize(function(){if(document_width!==$(document).width()||document_height!==$(document).height()){document_width=$(document).width();document_height=$(document).height();new UABBBlogPosts(args);}});new UABBBlogPosts(args);})(jQuery);