<?php
/* Template Name: Services Overview */
get_header();
?>
		<div class="row services-overview">
			<?php do_action('page_before_content'); ?>
			<div class="content-wrap col-md-12" id="page-wrap">
				<div class="row">
					<div class="col-md-6">
						<div class="left-col">
							<?php
								while(have_posts()){
									the_post();
									get_template_part('partials/loop');
								} // end while.
								
								
								$leftCol = get_posts(array(
									'post_type'				=>	'services',
									'posts_per_page'		=>	-1,
									'service_cat'			=>	'left-category',
									'orderby'				=>	'menu_order',
									'order'					=>	'ASC'
								));
								
								foreach($leftCol as $s) {
									$bg = get_post_meta($s->ID, 'bg_color', 1);
									$bgimg = wp_get_attachment_image_src( get_mu_custom_thumbnail_id($s->ID, 'service_icon'), 'full' );
									
									?>
									<div class="service-left <?php echo $s->post_name; ?>" style="background-color: <?php echo $bg; ?>; background-image: url(<?php echo $bgimg[0]; ?>);">
										<h4><?php echo $s->post_title; ?></h4>
										<p><?php echo $s->post_content; ?></p>
									</div>
									<?php
								}
							?>
						</div>
						
						<a href="<?php echo home_url('contact'); ?>/" style="font-weight: bold; margin: 25px 0; white-space: normal;" class="btn btn-primary btn-block">Get Started and Request a Quote</a>
					</div>
					<div class="col-md-6">
						<div class="right-col">
								
							<?php
							$rightCol = get_posts(array(
									'post_type'				=>	'services',
									'posts_per_page'		=>	-1,
									'service_cat'			=>	'right-category',
									'orderby'				=>	'menu_order',
									'order'					=>	'ASC'
								));
								
								
								$cols = array(
									"left"	=>	array(),
									"right"	=>	array()
								);
								
								$cols['left'] = array_slice($rightCol, 0, floor(count($rightCol) / 2));
								$cols['right'] = array_slice($rightCol, count($cols['left']));
								
								?>
								<div class="col-lg-6">
									<?php
									foreach($cols['left'] as $s) {
										$bg = get_post_meta($s->ID, 'bg_color', 1);
										$bgimg = wp_get_attachment_image_src( get_mu_custom_thumbnail_id($s->ID, 'service_icon'), 'full' );
										
										?>
											<div class="service-right <?php echo $s->post_name; ?>" style="background-color: <?php echo $bg; ?>; background-image: url(<?php echo $bgimg[0]; ?>);">
												<h4><?php echo $s->post_title; ?></h4>
												<p><?php echo $s->post_content; ?></p>
                                                <a href="<?php echo $s->post_name; ?>/" class="btn btn-default btn-sm btn-service">Learn More</a>
											</div>
										<?php
									}
									?>
								</div>
								<div class="col-lg-6">
									<?php
									foreach($cols['right'] as $s) {
										$bg = get_post_meta($s->ID, 'bg_color', 1);
										$bgimg = wp_get_attachment_image_src( get_mu_custom_thumbnail_id($s->ID, 'service_icon'), 'full' );
										
										?>
											<div class="service-right <?php echo $s->post_name; ?>" style="background-color: <?php echo $bg; ?>; background-image: url(<?php echo $bgimg[0]; ?>);">
												<h4><?php echo $s->post_title; ?></h4>
												<p><?php echo $s->post_content; ?></p>
                                                <a href="<?php echo $s->post_name; ?>/" class="btn btn-default btn-sm btn-service">Learn More</a>
											</div>
										<?php
									}
									?>
								</div>
						</div>
						
						<script>
							/*jQuery(function($) {
								$(".right-col").masonry({
									itemSelector: ".col-sm-6",
									transitionDuration: 0,
									isResizable: true
								});
								$(window).on('resize', function() {
									$(".right-col").masonry('layout');
								});
							});*/
						</script>
					</div>
				</div>
			</div>
			<?php do_action('page_after_content'); ?>
            
				<script type="text/javascript">
                // <![CDATA[ 
                window.__lc = window.__lc || {}; window.__lc.license = 6991721; (function() { var lc = document.createElement('script'); lc.type = 'text/javascript'; lc.async = true; lc.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'cdn.livechatinc.com/tracking.js'; var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(lc, s); })(); 
                // ]]></script>
                <!-- End of LiveChat code -->
                <script src="https://a.adtpix.com/px/?id=107095" type="text/javascript"></script>

		</div>
<?php get_footer(); ?>