<?php

/*

	Enqueued stylesheets and scripts in this file

*/


/*Remove Nivo Slider Styles and JS Optional */
//remove_action( 'wp_enqueue_scripts', 'enqueue_slider_scripts' );

if( !class_exists( 'Mindutopia_Enqueue' ) ) {
	class Mindutopia_Enqueue {

		var $template_dir;
		var $stylesheet_dir;
		var $fonts_stylesheet;

		function __construct(){

			add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ), 1 );
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 100 );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ), 100 );

			$this->template_dir = get_bloginfo( 'template_url' );
			$this->stylesheet_dir = get_bloginfo( 'stylesheet_directory' );
		}

		/*
			@Name: 		register_scripts
			@Purpose: 	add our js and css files.
		*/
		function register_scripts(){
			wp_register_script( 'handlebars',        $this->template_dir.'/js/lib/handlebars-v2.0.0.js' );
			wp_register_script( 'jquery-handlebars', $this->template_dir.'/js/lib/jquery-handlebars-1.1.4.min.js', array( 'handlebars', 'jquery' ) );
			if ( !is_admin() ) {
				wp_register_script( 'resource',          $this->template_dir.'/js/resource_v1.js', array( 'jquery' ) );
				
				wp_register_script( 'fancybox',          $this->template_dir.'/js/lib/fancybox/jquery.fancybox.pack.js', array( 'jquery' ) );
				wp_register_script( 'bootstrap-core',    $this->template_dir.'/js/bootstrap.min.js', array( 'jquery' ) );
				wp_register_script( 'jquery-cookie',     $this->template_dir.'/js/lib/jquery-cookie.js', array( 'jquery' ) );

				$deps = apply_filters( 'custom_js_dependencies', array( 'jquery', 'resource', 'bootstrap-core' ) );

				wp_register_script( 'custom', $this->template_dir.'/js/custom.js', $deps );
				wp_register_style( 'main-styles', get_bloginfo('stylesheet_url') );
				wp_register_style( 'custom-styles', $this->template_dir.'/custom.css', array(), false );
				
				/* 
					Filter to add fonts in your filters.php file:
					
					`mindutopia_custom_theme_fonts`
					
					@since 3.2.1
				*/
				
				$this->fonts_stylesheet = apply_filters( 'mindutopia_custom_theme_fonts', array() );
				
				if (  !empty( $this->fonts_stylesheet ) ) {
					if ( is_array( $this->fonts_stylesheet ) ) {
						foreach ( $this->fonts_stylesheet as $font => $sheet ) {
							wp_register_style( 'custom-font-'.$font, $sheet, array(), false );
						}
					}
					else if ( is_string( $this->fonts_stylesheet ) ) {
						wp_register_style( 'custom-font-style', $this->fonts_stylesheet, array(), false );
					}
				}
			}
		}

		/*
			@Name: 		mindutopia_enqueue_supplemental_scripts
			@Purpose: 	Create for any scripts that are for this site.
						Fonts.com css or js
			@Params: 	none
			@Returns: 	void
			@hooked:	wp_enqueue_scripts
		*/
		function enqueue_scripts(){
			if ( !is_admin() ) {

				wp_enqueue_script( 'jquery' );
				wp_enqueue_script( 'jquery-ui-core' );
				wp_enqueue_script( 'jquery-ui-datepicker' );
				wp_enqueue_script( 'resource' );
				wp_enqueue_script( 'bootstrap-core' );

				wp_enqueue_script( 'custom' );
				
				wp_enqueue_script('fancybox');

				wp_enqueue_style(  'main-styles' );
				wp_enqueue_style(  'custom-styles' );
				

				$sitedata = array(
					'ajax_url' => admin_url( 'admin-ajax.php' ),
					'root_url'	=>	home_url()
				);
				$sitedata = apply_filters( 'mu_site_js_data', $sitedata );

				wp_localize_script( 'custom', 'site_data', $sitedata );
				
				if(  !empty( $this->fonts_stylesheet ) ) {
					if ( is_array( $this->fonts_stylesheet ) ) {
						foreach ( $this->fonts_stylesheet as $font => $sheet ) {
							wp_enqueue_style( 'custom-font-'.$font );
						}
					}
					else if ( is_string( $this->fonts_stylesheet ) ) {
						wp_enqueue_style( 'custom-font-style' );
					}
				}
			}
		}

		/*
			@Name: 		mindutopia_enqueue_supplemental_scripts
			@Purpose: 	Create for any scripts that are for this site.
						Fonts.com css or js
			@Params: 	none
			@Returns: 	void
			@hooked:	wp_enqueue_scripts
		*/
		function admin_enqueue_scripts(){
			if ( is_admin() ) {
				
				/*
					@Name: 		add editor style sheet
					@Purpose: 	to change or add styles to show in the editor
					@Params: 	you can add/change the location of the file if you want.
					@Returns: 	just hooks
				*/
				add_editor_style('editor-style.css');
				
				if (  !empty( $this->fonts_stylesheet ) ) {
					if ( is_array( $this->fonts_stylesheet ) ) {
						foreach ( $this->fonts_stylesheet as $font => $sheet ) {
							$this->add_editor_font_stylesheet( $sheet );
						}
					}
					else if ( is_string( $this->fonts_stylesheet ) ) {
							$this->add_editor_font_stylesheet( $this->fonts_stylesheet );
					}
				}
				
				$deps = apply_filters( 'custom_admin_js_dependencies', array( 'jquery' ) );


				wp_register_script( 'mu-admin', $this->template_dir.'/js/admin.js' );
				wp_enqueue_script( 'mu-admin' );


				$sitedata = array(
					'ajax_url' => admin_url( 'admin-ajax.php' )
				);
				$sitedata = apply_filters( 'mu_site_js_data', $sitedata );

				wp_localize_script( 'mu-admin', 'site_data', $sitedata );
			}
		}
		
		/**
		 * Add each font to editor.
		 *
		 * Add google fonts appropriate for TinyMCE, 
		 * basically include all weights as their own sheets.
		 *
		 * @since 3.2.1
		 *
		 *
		 * @param  STRING $sheet stylesheet url.
		 * @return VOID nothing returned.
		 */
		function add_editor_font_stylesheet( $sheet ){
			
			$parts = explode( ':', $sheet );
						
			if ( count( $parts ) > 2 ) {
				$weights = explode( ',', $parts[2] );
				foreach ( $weights as $weight ) {
					add_editor_style( $parts[0] . ':' . $parts[1] . ':' . $weight );
				}
			}
			else{
				add_editor_style( $sheet );
			}
		}
	}
	function init_mindutopia_enqueue(){
		new Mindutopia_Enqueue();
	}
	
	add_action( 'init', 'init_mindutopia_enqueue' );
}

/*
	@Name:      homepage_js_filter
	@Purpose:   callback function for AJAX
	@Params:    (?)$data:pass data to custom.js
	@Returns:   $data
	@Action:    mu_site_js_data
*/
function homepage_js_filter( $data ){

	$data['home'] = is_front_page();

	return $data;
}
add_filter( 'mu_site_js_data', 'homepage_js_filter' );
