<?php 
	
	if( !class_exists('Mindutopia_Page_Meta') ){
		
		class Mindutopia_Page_Meta{
			function __construct(){
				

				//add save function to hook
				add_action('save_post', array( $this, 'update_custom_meta' ) );
				
				//add to admin_init
				add_action('add_meta_boxes_page', array( $this, 'add_page_custom_meta' ), 1, 1 );
			}
			
			function add_page_custom_meta( $post ) {
				
				$template = get_post_meta( $post->ID, '_wp_page_template', 1 );
				
				$template = ( empty($template) ) ? 'default' : $template;
				$template .= ( $template == 'default' ) ? '.php' : '';
				
				
				if( !empty( $template ) && locate_template('partials/admin/'.$template, false, false ) ) {
					
					$_template = basename( $template, '.php' );
					
					// add a filter to put custom titles on these meta boxes.
					$title = apply_filters( 'mu_custom_page_meta_box_title', 'Custom Details', $_template, $post );
					
					add_meta_box( 'page-custom-meta-default', $title, array( $this, 'page_custom_meta' ), 'page', 'advanced', 'core', array( 'template' => $_template ) );
				}
				
				do_action( 'template_support_custom', $template, $post );
			}
			
			//Admin Output
			function page_custom_meta( $post, $metabox ){
				wp_nonce_field( 'mu_custom_page_meta', 'mu_page_meta' );
				?>
				<a name="<?php echo $metabox['args']['template']; ?>-box"></a>
				<?php
				$this->load_template( $metabox['args']['template'], array( 'post' => $post ) );
			}
			
			function update_custom_meta( $post_id ){
				
				if ( isset( $_POST['mu_page_meta'] )  ) {
					check_admin_referer( 'mu_custom_page_meta', 'mu_page_meta' );
					// save stuff
					
					if ( isset( $_POST[ 'custom_page_meta' ] ) ) {
						foreach ( $_POST[ 'custom_page_meta' ] as $key => $value ) {
							if ( apply_filters( 'custom_page_meta-'.$key, true, $post_id, $key, $value ) ) {
								update_post_meta( $post_id, $key, $value );
							}
						}
					}
					
					if ( isset( $_POST[ 'delete_meta_if_empty' ] ) ) {
						foreach ( $_POST[ 'delete_meta_if_empty' ] as $_key ) {
							if( !isset( $_POST[ 'custom_page_meta' ][$_key] ) ) {
								delete_post_meta( $post_id, $_key );
							}
						} 
					}
				}
			}
			/**
			 * Get name for meta field
			 *
			 * provide a meta key get returned name string.
			 *
			 * @since 1.2
			 *
			 * @param  STRING   $key   Meta Key.
			 * @return STRING   Name of meta field
			 */
			function get_name( $_key ){
				$name = 'custom_page_meta['.$_key.']';
				return $name;
			}
			
			/**
			 * Get post meta inside of your admin page meta template.
			 *
			 * provide a post ID and meta key to retrieve the meta value saved to the database.
			 *
			 * @since 1.2
			 *
			 * @param  INT      $post  POST ID.
			 * @param  STRING   $key   Meta Key.
			 * @return MIXED    Meta value from database.
			 */
			
			function get_value( $post_id, $_key ){
				
				if( is_a($post_id, 'WP_Post') ) {
					$post_id = $post_id->ID;
				}
				
				$value = get_post_meta( $post_id, $_key, 1 );
				return $value;
			}
			
			function load_template( $template, $args = array() ){
				
				if ( !empty( $args ) ) { 
					extract( $args ); 
				}
				
				$path = locate_template( 'partials/admin/' . $template . '.php' , false );
				
				if ( file_exists( $path ) ) {
					include( $path );
				}				
			}

		}
		
		new Mindutopia_Page_Meta();
	}
/* 
	@Name:      mu_checked
	@Purpose:   to set checked or unchecked on radio buttons or checkboxes
	@Params:    (array)$haystack:array of values; (mixed)$needle:current value of input
	@Returns:   echos html
	@Action:    NONE
*/
function mu_checked($haystack, $needle){
	
	if ( ! empty( $haystack )  && is_array( $haystack ) ){
		if( in_array( $needle, $haystack ) ){
			echo 'checked="checked"';	
		}
	}
}

?>