<?php 
/*
	
Class for interacting with WP_Post Objects and Meta Quickly.
	
*/
class MU_Post_Helper {
	
	var $id;
	
	function __construct( $id = null ) {
		
		if( $id == null ) {
			$id = get_the_ID();
		}
		
		$this->id = $id;
	}
	
	/* 
		@Name: 		get
		@Purpose: 	get a value
		@Param: 	$key [STRING] meta key to get
		@Returns: 	[STRING]
	*/
	function get( $key ) {
		$val = get_post_meta( $this->id, $key, 1 );
		
		/* 
			Filter to allow manipulation out of Post Helper 
			mu_post_helper_val_filter-{$key}
			
			@since 3.2.1
		*/
		return apply_filters( 'mu_post_helper_val_filter-'.$key, $val );
	}
	
	/* 
		@Name: 		cecho
		@Purpose: 	Echo the value
		@Param: 	$key [STRING] meta key to get
		@Param: 	$shortcodes [BOOLEAN] whether or not to process shortcodes
		@Returns: 	VOID - Value echoed
	*/
	function cecho( $key, $shortcodes = false ) {
		$val = $this->get( $key );
		
		if( $shortcodes ) {
			$val = do_shortcode($val);
		}
		echo $val;
	}
	
	/* 
		@Name: 		autop
		@Purpose: 	wrap meta value in paragraph tags
		@Param: 	$key [STRING] meta key to get
		@Param: 	$shortcodes [BOOLEAN] whether or not to process shortcodes
		@Returns: 	VOID - Value echoed
	*/
	function autop( $key, $shortcodes = false ) {
		$val = $this->get( $key );
		
		if( $shortcodes ) {
			$val = do_shortcode($val);
		}
		
		echo wpautop($val);
	}
	
	/* 
		@Name: 		has
		@Purpose: 	Detect if the meta value exists or not
		@Param: 	$key [STRING] meta key to get
		@Returns: 	[BOOLEAN]
	*/
	function has( $key ) {
		return (boolean) $this->get( $key );
	}
}