<?php 
	
/*
-----------------------------------------

	Try to keep filters in this file.

-----------------------------------------
*/



/* 
	@Name: 		footer_variables_filter
	@Purpose: 	Simple string replace of variables for current year
	@Params: 	$str
	@Returns: 	$str
	@Hooked:	footer_copyright
*/
function footer_variables_filter( $str ){
	$str = str_replace(
		array( '%year%', '%blogname%'),
		array( date('Y'), get_bloginfo('name') ),
		$str
	);
	return $str;
}

add_filter( 'footer_copyright', 'footer_variables_filter', 10, 1 );

function fonts_com($fnts) {
	$fnts['fontscom']		=	'//fast.fonts.net/cssapi/42cb4ea7-2cfc-435e-ae60-e42b6c012149.css';
	$fnts['jqueryui']		=	'//ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/themes/smoothness/jquery-ui.css';
	
	return $fnts;
}
add_filter('mindutopia_custom_theme_fonts', 'fonts_com');

function hero_title_html($a) {
	if(!empty($a)) {
		ob_start();
		?>
		<div class="hero-title-wrapper">
			<div class="hero-title"><?php echo $a; ?></div>
		</div>
		<?php
		$content = ob_get_contents();
		ob_clean();
		return $content;
	}
	else {
		return '';
	}
}
add_filter('hero_title', 'hero_title_html');

/* 
	@Name: 		mindutopia_theme_init
	@Purpose: 	filter added to post class [does, first, last, even, odd]
*/
function mindutopia_post_class( $classes ){	
	global $wp_query;
	
	$last = $wp_query->post_count;
	$current = $wp_query->current_post;
	
	if($current == 0){
		$classes[] = 'first';
	}
	if($current+1 == $last){
		$classes[] = 'last';
	}
	if( $current%2 ){
		$classes[] = 'even';
	}
	else{
		$classes[] = 'odd';
	}
	return $classes;
}

add_filter('post_class', 'mindutopia_post_class');

/* 
	@Name: 		mindutopia_parent_class
	@Purpose: 	filter on the body class to add parent section class @ryanwhinkle woot.
*/
function mindutopia_parent_class($classes){
	if ( is_page() ) {
		$page_ID = get_the_ID();
		
		$parents_array = get_post_ancestors($page_ID);
		
		$reverse_parent = array_reverse($parents_array);
		$count = 1;
		foreach ( $reverse_parent as $parent ) {
			$classes[] = 'level-'.$count.'-'.strtolower(str_replace(' ','_',get_the_title($parent)));
			$count++;
		}
	}
	return $classes;
}
add_filter('body_class','mindutopia_parent_class');

/* --------------------------------------------
 * Name: custom_body_classes()
 * Purpose: Filter body_class to include user browser, category, and date classes
 			(Thanks to Brian Richards at StartBox)
 * Params: $classes
 * Returns: $classes
-------------------------------------------- */
// Filter body_class to include user browser, category, and date classes
function custom_body_classes($classes) {
	global $wp_query;
	
	// Adds category classes for each category on single posts
	if ( $cats = get_the_category() )
		foreach ( $cats as $cat )
			$classes[] = 's-category-' . $cat->slug;
			
	// Applies the time- and date-based classes
    /* sb_date_classes( time(), $classes, $p = null );

	// Adds classes for the month, day, and hour when the post was published
	if ( is_single() )
		sb_date_classes( mysql2date( 'U', $wp_query->post->post_date ), $classes, 's-' );
		*/
	
	// Adds post and page slug class, prefixed by 'post-' or 'page-', respectively
	if ( is_single() )
    	$classes[] = 'post-' . $wp_query->post->post_name;
	elseif( is_page() )
		$classes[] = 'page-' . $wp_query->post->post_name;
		
	// return the $classes array
	return $classes;
}
add_filter('body_class','custom_body_classes');

/* 
	@Name: 		menu_set_dropdown
	@Purpose: 	filter the dropdown class to the nav menus
	@Params: 	$sorted_items, $args
	@Returns: 	$sorted_items
	@Hooked:	`wp_nav_menu_objects`
*/
function menu_set_dropdown( $sorted_menu_items, $args ) {
    $last_top = 0;
    foreach ( $sorted_menu_items as $key => $obj ) {
        // it is a top lv item?
        if ( 0 == $obj->menu_item_parent ) {
            // set the key of the parent
            $last_top = $key;
        } else {
            $sorted_menu_items[$last_top]->classes['dropdown'] = 'dropdown';
        }
    }
    return $sorted_menu_items;
}
add_filter( 'wp_nav_menu_objects', 'menu_set_dropdown', 10, 2 );

/* 
	@Name: 		nav_item_first_last_filter
	@Purpose: 	add first and last class to nav items
	@Params: 	$objects 
	@Returns: 	objects with classes appened.
	@Hooked:	wp_nav_menu_objects
*/
function nav_item_first_last_filter( $objects ){
	// Add "first-menu-item" class to the first menu object
    $objects[1]->classes[] = 'first';
 
    // Add "last-menu-item" class to the last menu object
    $objects[count( $objects )]->classes[] = 'last';
 
    // Return the menu objects
    return $objects;
}
add_filter( 'wp_nav_menu_objects', 'nav_item_first_last_filter', 11, 1 );



/**
 * add data tag for retinajs not to output media library images.
 *
 * @since Base Theme v3.2.3
 *
 * @hooked wp_get_attachment_image_attributes, 1, 1
 *
 * @param  ARRAY $attr  array of html attributes.
 * @return ARRAY modified array.
 */
function mu_data_no_retina_filter( $attr ){
	$attr['data-no-retina'] = true;
	return $attr;
}
add_filter( 'wp_get_attachment_image_attributes', 'mu_data_no_retina_filter', 1 );


/**
 * Add the data no retina tag on sending to WP Editor.
 *
 *
 * @since Base Theme v3.2.3
 *
 * @hooked image_send_to_editor, 10, 8
 *
 * @param  STRING $html    HTML image tag.
 * @param  INT    $id      Attachment ID.
 * @param  STRING $caption Caption image string.
 * @param  STRING $title   Image post title.
 * @param  STRING $align   CSS align class.
 * @param  STRING $url     Img SRC url.
 * @param  STRING $size    Image size.
 * @param  STRING $alt     Alt text for image tag.
 *
 * @return STRING Modified HTML string.
 */

function mu_add_responsive_image_class( $html, $id, $caption, $title, $align, $url, $size, $alt ) {
	
	$html = str_ireplace( array( 'class="', '<img' ) , array( 'class="img-responsive ', '<img data-no-retina="1"' ), $html );
	return $html;
}
add_filter( 'image_send_to_editor', 'mu_add_responsive_image_class', 10, 8 );

add_filter( 'oembed_dataparse', 'responsive_oembeds', 10, 2 );

function responsive_oembeds( $return, $data ){
	
	if ( $data->type == 'rich' || $data->type == 'video' ) {
		// add class
		
		/*$return = str_replace( array( 'class="', "class='" ), array( 'class="embed-responsive-item ', "class='embed-responsive-item " ), $return ); 
		
		if ( stripos( $return, 'embed-responsive-item' ) === false ) {
			$return = preg_replace('/" /', '" class="embed-responsive-item" ', $return, 1 );
		}
		
		$ratio = ( round( ( $data->width / $data->height ) , 2 ) == 1.3 )  ? 'embed-responsive-4by3' : 'embed-responsive-16by9';
		$return = '<div class="embed-responsive '.$ratio.'">'.$return.'</div>';
		
		$return = str_replace('feature=oembed', 'feature=oembed&rel=0', $return);*/
		
		//JK use YT API
		
		$url = $data->html;
		$url = explode('src="', $url);
		$url = $url[1];
		//$url = substr($url, 0, strpos('"', $url));
		
		preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $match);
		
		$return = '';
		ob_start();
		
		$ratio = ( round( ( $data->width / $data->height ) , 2 ) == 1.3 )  ? 'embed-responsive-4by3' : 'embed-responsive-16by9';
		
		?>
		<div class="embed-responsive <?php echo $ratio; ?>">
			<div class="embed-responsive-item" id="ytplayer"></div>
		</div>
		
		<script>
			jQuery(function($) {
				var tag = document.createElement('script');

			      tag.src = "https://www.youtube.com/iframe_api";
			      var firstScriptTag = document.getElementsByTagName('script')[0];
			      firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
			});
			var ytp;
			function onYouTubeIframeAPIReady() {
				ytp = new YT.Player('ytplayer', {
					videoId:	'<?php echo $match[1]; ?>',
					playerVars:	{
						modestbranding:	1,
						rel:			0
					},
					events:		{
						'onStateChange'	:	onPlayerStateChange
					}
				});
			}
		</script>
		<?php
		
		$return = ob_get_contents();
		ob_clean();
	}
	
	return $return;
}