<?php

function recent_posts_widget($args) {
	$cat = array_key_exists('cat', $args) ? $args['cat'] : '';
	$numPosts = array_key_exists('maxposts', $args) ? $args['maxposts'] : 5;
	
	ob_start();
	
	$posts = get_posts(array(
		'category_name'		=>	$cat,
		'posts_per_page'	=>	$numPosts,
		'post_type'			=>	'post'
	));
	?>
	<div class="recent-posts">
	<?php
	foreach($posts as $p) {
		//print_r($p);
		?>
		<a href="<?php echo $p->guid; ?>" class="post-link">
			<h1><?php echo $p->post_title; ?></h1>
			<p><?php echo $p->post_excerpt != '' ? $p->post_excerpt : $p->post_content; ?></p>
		</a>
		<?php
	}
	?>
	</div>
	<?php
	
	$content = ob_get_contents();
	ob_clean();
	
	return $content;
}

add_shortcode('recent_posts', 'recent_posts_widget');

/* 
	@Name: 		mindutopia_theme_init
	@Purpose: 	Hooked into init to add our theme support stuff
*/
function mindutopia_theme_init(){
	register_nav_menu( 'main', 'Main navigation menu' );
	register_nav_menu( 'footer', 'Footer nav menu' );
	add_theme_support( 'post-thumbnails' );
}

/* Theme Support
	@Name: 		mindutopia_theme_init
	@Purpose: 	Hooked into widgets_init to add our sidebar call outs.
*/
function mindutopia_register_sidebars(){
	register_sidebar(
		array(
			'name'          => 'Default Sidebar',
			'id'            => 'default-sidebar',
			'description'   => '',
		    'class'         => '',
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget'  => '</li>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>' 
		)
	);
}

function mu_after_content() {
	if(is_front_page()) {
		get_template_part('partials/front/blocks');
	}
}

function mu_before_footer() {
	get_template_part('partials/footer/top-block');
}

function mu_custom_page_title() {
	global $post;
	if($post->post_type == 'page') {
		?>
		<input type="text" name="mu_hero_title" placeholder="Enter hero title... (optional)" value="<?php echo get_post_meta($post->ID, 'mu_hero_title', 1); ?>" class="widefat">
		<?php
	}
}
function mu_custom_page_title_save() {
	global $post;
	if($post->post_type == 'page') {
		if(isset($_POST["mu_hero_title"])) {
			update_post_meta($post->ID, 'mu_hero_title', $_POST["mu_hero_title"]);
		}
		
		if(isset($_POST["sidebar_content"])) {
			update_post_meta($post->ID, 'sidebar_content', $_POST["sidebar_content"]);
		}
	}
}

function mu_custom_sidebar() {
	global $post;
	if(basename(get_page_template()) == 'landing-page.php') {
		?>
		<hr>
		<h1>Edit Sidebar</h1>
		<?php
		wp_editor(get_post_meta($post->ID, 'sidebar_content', 1), 'sidebar_content', array( 'media_buttons' => true, 'textarea_name' => 'sidebar_content', 'textarea_rows' => 5));
	}
}


function get_staff_bio() {
			$staff = $_GET["staff"];
			
			$item = get_post($staff);
			$img = wp_get_attachment_image_src( get_post_thumbnail_id($item->ID), 'large' );
			$meta = get_post_meta($item->ID);
			?>
			<div class="container-fluid staff-popup">
				<div class="row">
					<div class="col-sm-8">
						<h1 class="name"><?php echo $item->post_title; ?></h1>
						<h4><?php echo $meta['staff_title'][0]; ?></h4>
						
						<hr>
						<?php echo apply_filters('the_content', $item->post_content); ?>
					</div>
					<div class="col-sm-4">
						<img src="<?php echo $img[0]; ?>" class="img-responsive">
					</div>
				</div>
			</div>
			<?php
			
			wp_die();
		}

add_action('wp_ajax_nopriv_staff_content', 'get_staff_bio');
add_action('wp_ajax_staff_content', 'get_staff_bio');

// Actions.
add_action('after_setup_theme', 'mindutopia_theme_init', 1);
add_action('widgets_init', 'mindutopia_register_sidebars');

add_action('page_after_content', 'mu_after_content');
add_action('before_footer', 'mu_before_footer');

add_action('edit_form_before_permalink', 'mu_custom_page_title');
add_action('save_post', 'mu_custom_page_title_save');

add_action('edit_form_after_editor', 'mu_custom_sidebar');